--  
require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
GameObject = {
    Params = {
        ID="crow";
        width=1;
        height=1;
        --health=3200;
        RandomTasks=0;
        GridData= { 
            1
        };
        group=7; -- 
    };
    ActivePoints = { 
        evil = { 
                   { {}, 2,1,0,  0,  0,0,0 };
                   }; 
    };
    Objects = {};
    -- list of all tasks for an object
    Tasks = {
        evil = { FuncName="EvilTaskExecute", sleeping={0}, not_need_action=1, skill_up = 0, restore_health=1000 };
        sleep_end = { FuncName="StopOnEndTaskExecute", hand_add=1 };
    };
    -- list of all triggers for an object
    Triggers = { 
        Evil = {FuncName="EvilTriger", NotRunWhen={"evil"}, timer={ 38 }, first_timer={ 5 }, amount=2, cur_value=0 }
    };
    --tasks to be performed after an object is created
    InitActiveTasks = {};
    --tasks an object is waiting ofr after it is created
    InitExpectedTasks = {};
};
function GameObject:Get()
    return self;
end


--        
function OnInit()
    aObj = GameObject:Get();   
    if( not aObj.Params.MaxHealth )then
        aObj.Params.MaxHealth = aObj.Params.health;
    end;
end
    

function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end

-- perform Task EATING over external object and return true if task is completed
function EvilTaskExecute()
    aObject = GameObject:Get();
    aObject.Triggers.Evil.amount = aObject.Triggers.Evil.amount - 1;
    aObject.Triggers.Evil.under_task = 0;
    CPP_SetAnimState("invisible");
    CPP_StopSound("crow_evil");
    return 0;
end

function EvilTriger()
    aObj = GameObject:Get();
    local aTrigger = aObj.Triggers.Evil;
    --         
    if (aTrigger.amount <= 0) then return; end
    --      
    if (aTrigger.under_task == 1) then 
        return; 
    end
    
    if ((not aTrigger.cur_value) or (aTrigger.cur_value == 0)) then
        aTrigger.cur_value = GetTriggerTimerRand(aTrigger);
        return;
    end
    
    aTrigger.cur_value = aTrigger.cur_value - 1;
    if (aTrigger.cur_value <= 0) then
        aTrigger.cur_value = 0;
        --      
        aTrigger.under_task = 1;
        CPP_AddExpectedTasks("evil");
        CPP_WantSelect(1);
        CPP_PlaySound("crow_evil",1);
        CPP_SetAnimState("activate");
        --  ,   
        CPP_RecursiveRun("evil_crow",0);
    end
end

function StopOnEndTaskExecute()
    CPP_StopSound("crow_evil");
    CPP_SetAnimState("invisible");
    return 0;
end
